within ;
model CentrifugalClutch

  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a
    annotation (Placement(transformation(extent={{-86,36},{-66,56}})));
  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_b
    annotation (Placement(transformation(extent={{60,36},{80,56}})));
  Modelica.Mechanics.Rotational.Components.Clutch clutch(
    peak=1.1,
    cgeo=2,
    fn_max=100)
    annotation (Placement(transformation(extent={{-8,36},{12,56}})));
  Modelica.Blocks.Tables.CombiTable1Ds combiTable1Ds(smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments,
      table=[0,0; 400,0; 1000,1; 30000,1])
    annotation (Placement(transformation(extent={{-28,64},{-8,84}})));
  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=0.005)
    annotation (Placement(transformation(extent={{-58,36},{-38,56}})));
  Modelica.Mechanics.Rotational.Components.Inertia inertia1(J=0.005)
    annotation (Placement(transformation(extent={{30,36},{50,56}})));
  Modelica.Blocks.Math.Product product
    annotation (Placement(transformation(extent={{16,-26},{36,-6}})));
  Modelica.Blocks.Sources.Constant const(k=9.54929659643)
    annotation (Placement(transformation(extent={{-22,-38},{-2,-18}})));
  Modelica.Mechanics.Rotational.Components.Damper damper1(d=0.00083333)
    annotation (Placement(transformation(extent={{-44,-10},{-64,10}})));
  Modelica.Mechanics.Rotational.Components.Fixed fixed1
    annotation (Placement(transformation(extent={{-82,-38},{-62,-18}})));
  Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor
    annotation (Placement(transformation(extent={{-16,-2},{4,18}})));
equation
  connect(combiTable1Ds.y[1], clutch.f_normalized) annotation (Line(
      points={{-7,74},{2,74},{2,57}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(inertia.flange_a, flange_a) annotation (Line(
      points={{-58,46},{-76,46}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia.flange_b, clutch.flange_a) annotation (Line(
      points={{-38,46},{-8,46}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(clutch.flange_b, inertia1.flange_a) annotation (Line(
      points={{12,46},{30,46}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia1.flange_b, flange_b) annotation (Line(
      points={{50,46},{70,46}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(const.y, product.u2) annotation (Line(
      points={{-1,-28},{6,-28},{6,-22},{14,-22}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(product.y, combiTable1Ds.u) annotation (Line(
      points={{37,-16},{94,-16},{94,96},{-66,96},{-66,74},{-30,74}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(fixed1.flange, damper1.flange_b) annotation (Line(
      points={{-72,-28},{-72,0},{-64,0}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(damper1.flange_a, inertia.flange_b) annotation (Line(
      points={{-44,0},{-30,0},{-30,46},{-38,46}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(speedSensor.w, product.u1) annotation (Line(
      points={{5,8},{10,8},{10,-10},{14,-10}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(speedSensor.flange, inertia.flange_b) annotation (Line(
      points={{-16,8},{-26,8},{-26,46},{-38,46}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")),
    Diagram(graphics),
    Icon(graphics={Text(
          extent={{-70,86},{82,-66}},
          lineColor={0,0,255},
          textString="Centrifugal Clutch")}));
end CentrifugalClutch;
